/*
 * Decompiled with CFR 0.152.
 */
package link.infra.packwiz.installer.bootstrap;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import link.infra.packwiz.installer.bootstrap.LoadJAR;
import link.infra.packwiz.installer.bootstrap.RollbackHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static final String DEFAULT_UPDATE_URL = "https://api.github.com/repos/comp500/packwiz-installer/releases/latest";
    public static final String JAR_NAME = "packwiz-installer.jar";
    private String updateURL = "https://api.github.com/repos/comp500/packwiz-installer/releases/latest";
    private boolean skipUpdate = false;
    private boolean useGUI = true;
    private String jarPath = null;
    private String accessToken = null;

    public static void main(String[] args) {
        new Main(args);
    }

    public Main(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (ParseException e) {
            this.showError(e, "There was an error parsing command line arguments:");
            System.exit(1);
        }
        if (this.jarPath == null) {
            this.jarPath = JAR_NAME;
        }
        if (this.useGUI) {
            EventQueue.invokeLater(() -> {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (this.skipUpdate) {
            try {
                LoadJAR.start(args, this.jarPath);
            }
            catch (ClassNotFoundException e) {
                this.showError(e, "packwiz-installer cannot be found, or there was an error loading it:");
                System.exit(1);
            }
            catch (Exception e) {
                this.showError(e, "There was an error loading packwiz-installer:");
                System.exit(1);
            }
            return;
        }
        try {
            this.doUpdate();
        }
        catch (Exception e) {
            this.showError(e, "There was an error downloading packwiz-installer:");
        }
        try {
            LoadJAR.start(args, this.jarPath);
        }
        catch (Exception e) {
            this.showError(e, "There was an error loading packwiz-installer (did it download properly?):");
            System.exit(1);
        }
    }

    private void doUpdate() throws IOException, GithubException {
        String currVersion = LoadJAR.getVersion(this.jarPath);
        Release ghRelease = this.requestRelease();
        if (ghRelease == null) {
            return;
        }
        System.out.println("Current version is: " + currVersion);
        System.out.println("New version is: " + ghRelease.tagName);
        if (!ghRelease.tagName.equals(currVersion)) {
            System.out.println("Attempting to update...");
            RollbackHandler backup = new RollbackHandler(this.jarPath);
            try {
                this.downloadUpdate(ghRelease.downloadURL, ghRelease.assetURL, this.jarPath);
            }
            catch (InterruptedIOException e) {
                try {
                    backup.rollback();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                this.showError(e, "Update download failed, attempting to rollback:");
                try {
                    backup.rollback();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            System.out.println("Update successful!");
        } else {
            System.out.println("Already up to date!");
        }
    }

    private void showError(Exception e, String message) {
        if (this.useGUI) {
            e.printStackTrace();
            try {
                EventQueue.invokeAndWait(() -> JOptionPane.showMessageDialog(null, message + "\n" + e.getClass().getCanonicalName() + ": " + e.getMessage(), "packwiz-installer-bootstrap", 0));
            }
            catch (InterruptedException | InvocationTargetException ex) {
                System.out.println("Unexpected interruption while showing error message");
                ex.printStackTrace();
            }
        } else {
            System.out.println(message);
            e.printStackTrace();
        }
    }

    private void parseOptions(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(null, "bootstrap-update-url", true, "Github API URL for checking for updates");
        options.addOption(null, "bootstrap-update-token", true, "Github API Access Token, for private repositories");
        options.addOption(null, "bootstrap-no-update", false, "Don't update packwiz-installer");
        options.addOption(null, "bootstrap-main-jar", true, "Location of the packwiz-installer JAR file");
        options.addOption("g", "no-gui", false, "Don't display a GUI to show update progress");
        options.addOption("h", "help", false, "Display this message");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, this.filterArgs(args, options));
        if (cmd.hasOption("bootstrap-main-jar")) {
            this.jarPath = cmd.getOptionValue("bootstrap-main-jar");
        }
        if (cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            boolean jarLoaded = LoadJAR.addOptions(options, this.jarPath);
            formatter.printHelp("java -jar packwiz-installer-bootstrap.jar", options);
            if (!jarLoaded) {
                System.out.println("Options for packwiz-installer will be visible once it has been downloaded.");
            }
            System.exit(0);
        }
        if (cmd.hasOption("bootstrap-update-url")) {
            this.updateURL = cmd.getOptionValue("bootstrap-update-url");
        }
        if (cmd.hasOption("bootstrap-update-token")) {
            this.accessToken = cmd.getOptionValue("bootstrap-update-token");
        }
        if (cmd.hasOption("bootstrap-no-update")) {
            this.skipUpdate = true;
        }
        if (cmd.hasOption("no-gui")) {
            this.useGUI = false;
        }
    }

    private String[] filterArgs(String[] args, Options options) {
        ArrayList<String> argsList = new ArrayList<String>(args.length);
        boolean prevOptWasArg = false;
        for (String arg : args) {
            if (arg.charAt(0) == '-' && options.hasOption(arg)) {
                if (options.getOption(arg).hasArg()) {
                    prevOptWasArg = true;
                }
            } else {
                if (!prevOptWasArg) continue;
                prevOptWasArg = false;
            }
            argsList.add(arg);
        }
        return argsList.toArray(new String[0]);
    }

    private Release requestRelease() throws IOException, GithubException {
        JsonObject object;
        Release rel = new Release();
        URL url = new URL(this.updateURL);
        if (this.accessToken != null) {
            url = new URL(this.updateURL + "?access_token=" + this.accessToken);
        }
        URLConnection conn = url.openConnection();
        conn.setReadTimeout(30000);
        InputStream in = this.useGUI ? new ConnMonitorInputStream(conn, "Checking for packwiz-installer updates...", null) : conn.getInputStream();
        InputStreamReader streamReader = new InputStreamReader(in);
        try {
            object = Json.parse(streamReader).asObject();
        }
        catch (InterruptedIOException e) {
            System.out.println("Update check cancelled!");
            return null;
        }
        ((Reader)streamReader).close();
        JsonValue tagName = object.get("tag_name");
        if (tagName == null || !tagName.isString()) {
            throw new GithubException("Tag name cannot be found");
        }
        rel.tagName = tagName.asString();
        JsonValue assets = object.get("assets");
        if (assets == null || !assets.isArray()) {
            throw new GithubException("Assets array cannot be found");
        }
        for (JsonValue assetValue : assets.asArray()) {
            if (!assetValue.isObject()) {
                throw new GithubException();
            }
            JsonObject asset = assetValue.asObject();
            JsonValue name = asset.get("name");
            if (name == null || !name.isString()) {
                throw new GithubException("Asset name cannot be found");
            }
            if (!name.asString().equalsIgnoreCase(JAR_NAME)) continue;
            JsonValue downloadURL = asset.get("browser_download_url");
            if (downloadURL == null || !downloadURL.isString()) {
                throw new GithubException("Asset Download URL cannot be found");
            }
            rel.downloadURL = downloadURL.asString();
            JsonValue assetURL = asset.get("url");
            if (assetURL == null || !assetURL.isString()) {
                throw new GithubException("Asset Download URL cannot be found");
            }
            rel.assetURL = assetURL.asString();
            break;
        }
        if (rel.tagName == null) {
            throw new GithubException("Latest release asset cannot be found");
        }
        return rel;
    }

    private void downloadUpdate(String downloadURL, String assetURL, String path) throws IOException {
        URL url = new URL(downloadURL);
        if (this.accessToken != null) {
            url = new URL(assetURL + "?access_token=" + this.accessToken);
        }
        URLConnection conn = url.openConnection();
        conn.addRequestProperty("Accept", "application/octet-stream");
        conn.setReadTimeout(30000);
        InputStream in = this.useGUI ? new ConnMonitorInputStream(conn, "Updating packwiz-installer...", null) : conn.getInputStream();
        Files.copy(in, Paths.get(path, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        in.close();
    }

    static class ConnMonitorInputStream
    extends InputStream {
        private InputStream in = null;
        private int size = -1;
        private int bytesRead = 0;
        private final URLConnection conn;
        private ProgressMonitor mon;
        private final AtomicBoolean wasCancelled = new AtomicBoolean();
        private long lastMillisUpdated = System.currentTimeMillis() - 110L;

        public ConnMonitorInputStream(URLConnection conn, String message, String note) {
            this.conn = conn;
            EventQueue.invokeLater(() -> {
                this.mon = new ProgressMonitor(null, message, note, 0, 1);
                this.mon.setMillisToDecideToPopup(1);
                this.mon.setMillisToPopup(1);
            });
        }

        private void setup() throws IOException {
            if (this.in == null) {
                try {
                    this.size = this.conn.getContentLength();
                    this.in = this.conn.getInputStream();
                    EventQueue.invokeLater(() -> {
                        this.mon.setProgress(0);
                        if (this.size > -1) {
                            this.mon.setMaximum(this.size);
                        }
                    });
                }
                catch (IOException e) {
                    EventQueue.invokeLater(() -> this.mon.close());
                    throw e;
                }
            }
        }

        @Override
        public int available() {
            if (this.size > -1) {
                return this.size - this.bytesRead;
            }
            return 1;
        }

        private void setProgress() throws InterruptedIOException {
            if (System.currentTimeMillis() - this.lastMillisUpdated < 100L) {
                return;
            }
            this.lastMillisUpdated = System.currentTimeMillis();
            int progress = this.size > -1 ? this.bytesRead : -1;
            EventQueue.invokeLater(() -> {
                if (progress > -1) {
                    this.mon.setProgress(progress);
                }
                this.wasCancelled.set(this.mon.isCanceled());
            });
            if (this.wasCancelled.get()) {
                throw new InterruptedIOException("Download cancelled!");
            }
        }

        @Override
        public int read() throws IOException {
            this.setup();
            int b = this.in.read();
            if (b != -1) {
                ++this.bytesRead;
                this.setProgress();
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.setup();
            int read = this.in.read(b);
            this.bytesRead += read;
            this.setProgress();
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.setup();
            int read = this.in.read(b, off, len);
            this.bytesRead += read;
            this.setProgress();
            return read;
        }

        @Override
        public void close() throws IOException {
            super.close();
            EventQueue.invokeLater(() -> this.mon.close());
            if (this.wasCancelled.get()) {
                throw new InterruptedIOException("Download cancelled!");
            }
        }
    }

    private static class GithubException
    extends Exception {
        private static final long serialVersionUID = 3843811090801607241L;

        public GithubException() {
            super("Invalid Github API response");
        }

        public GithubException(String message) {
            super("Invalid Github API response: " + message);
        }
    }

    private static class Release {
        String tagName = null;
        String downloadURL = null;
        String assetURL = null;

        private Release() {
        }
    }
}

